﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace American_Colonies
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private int SequentialSearch(string[] sArray, string value)
        {
            bool found = false;  // Flaga oznaczająca wynik operacji wyszukiwania.
            int index = 0;       // Zmienna używana do iteracji przez tablicę.
            int position = -1;   // Położenie wartości, o ile zostanie znaleziona.
        
            // Przeszukiwanie tablicy.
            while (!found && index<sArray.Length)
            {
                if (sArray[index] == value)
                {
                    found = true;
                    position = index;
                }
        
                index++;
            }
        
            // Zwrot znalezionego położenia.
            return position;
        }

        private void okButton_Click(object sender, EventArgs e)
        {
            string selection;   // Zmienna przechowująca element wybrany przez użytkownika.

            // Utworzenie tablicy wraz z nazwami kolonii.
            string[] colonies = { "Delaware", "Pensylwania", "New Jersey",
                                  "Georgia", "Connecticut", "Massachusetts",
                                  "Maryland", "Karolina Południowa", "New Hampshire",
                                  "Wirginia", "Nowy Jork", "Karolina Północna",
                                  "Rhode Island" };

            if (selectionListBox.SelectedIndex != -1)
            {
                // Pobranie zaznaczonego elementu.
                selection = selectionListBox.SelectedItem.ToString();

                // Ustalenie, czy element znajduje się w tablicy.
                if (SequentialSearch(colonies, selection) != -1)
                {
                    MessageBox.Show("Tak, to była jedna z początkowych kolonii.");
                }
                else
                {
                    MessageBox.Show("Nie, to nie była jedna z początkowych kolonii.");
                }
            }
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
